/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.WebpageLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public final class WebpagePanel
extends JPanel {
    private static final Logger log = Logger.getLogger(WebpagePanel.class.getName());
    private final WebpagePanel self = this;
    private URL url;
    private boolean activated;
    private JEditorPane documentView;
    private JScrollPane documentScroll;
    private JProgressBar progressBar;
    private Thread thread;
    private Border browserBorder;

    public static WebpagePanel forURL(URL url, boolean lazy) {
        return new WebpagePanel(url, lazy);
    }

    public static WebpagePanel forHTML(String html) {
        return new WebpagePanel(html);
    }

    private WebpagePanel(URL url, boolean lazy) {
        this.url = url;
        this.setLayout(new BorderLayout());
        if (lazy) {
            this.setPlaceholder();
        } else {
            this.setDocument();
            this.fetchAndDisplay(url);
        }
    }

    private WebpagePanel(String text) {
        this.url = null;
        this.setLayout(new BorderLayout());
        this.setDocument();
        this.setDisplay(text, null);
    }

    public WebpagePanel(boolean lazy) {
        this.url = null;
        this.setLayout(new BorderLayout());
        if (lazy) {
            this.setPlaceholder();
        } else {
            this.setDocument();
        }
    }

    public Border getBrowserBorder() {
        return this.browserBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrowserBorder(Border browserBorder) {
        WebpagePanel webpagePanel = this;
        synchronized (webpagePanel) {
            this.browserBorder = browserBorder;
            if (this.documentScroll != null) {
                this.documentScroll.setBorder(browserBorder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocument() {
        this.activated = true;
        JLayeredPane panel = new JLayeredPane();
        panel.setLayout(new WebpageLayoutManager());
        this.documentView = new JEditorPane();
        this.documentView.setOpaque(false);
        this.documentView.setBorder(null);
        this.documentView.setEditable(false);
        this.documentView.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                    SwingHelper.openURL(e.getURL(), (Component)WebpagePanel.this.self);
                }
            }
        });
        this.documentScroll = new JScrollPane(this.documentView);
        this.documentScroll.setOpaque(false);
        panel.add((Component)this.documentScroll, new Integer(1));
        this.documentScroll.setVerticalScrollBarPolicy(22);
        WebpagePanel webpagePanel = this;
        synchronized (webpagePanel) {
            if (this.browserBorder != null) {
                this.documentScroll.setBorder(this.browserBorder);
            }
        }
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        panel.add((Component)this.progressBar, new Integer(2));
        SwingHelper.removeOpaqueness(this);
        SwingHelper.removeOpaqueness(this.documentView);
        SwingHelper.removeOpaqueness(this.documentScroll);
        this.add((Component)panel, "Center");
    }

    private void setPlaceholder() {
        this.activated = false;
        JLayeredPane panel = new JLayeredPane();
        panel.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        panel.setLayout(new BoxLayout(panel, 1));
        final JButton showButton = new JButton("Load page");
        showButton.setAlignmentX(0.5f);
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                showButton.setVisible(false);
                WebpagePanel.this.setDocument();
                WebpagePanel.this.fetchAndDisplay(WebpagePanel.this.url);
            }
        });
        panel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(1000, 1000)));
        panel.add(showButton);
        panel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(1000, 1000)));
        this.add((Component)panel, "Center");
    }

    public boolean browse(URL url, boolean onlyChanged) {
        if (onlyChanged && this.url != null && this.url.equals(url)) {
            return false;
        }
        this.url = url;
        if (this.activated) {
            this.fetchAndDisplay(url);
        }
        return true;
    }

    private synchronized void fetchAndDisplay(URL url) {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.progressBar.setVisible(true);
        this.thread = new Thread(new FetchWebpage(url));
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void setDisplay(String text, URL baseUrl) {
        this.progressBar.setVisible(false);
        this.documentView.setContentType("text/html");
        HTMLDocument document = (HTMLDocument)this.documentView.getDocument();
        Enumeration<?> e = document.getStyleNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            document.removeStyle((String)o);
        }
        document.setBase(baseUrl);
        this.documentView.setText(text);
        this.documentView.setCaretPosition(0);
    }

    private void setError(String text) {
        this.progressBar.setVisible(false);
        this.documentView.setContentType("text/plain");
        this.documentView.setText(text);
        this.documentView.setCaretPosition(0);
    }

    private class FetchWebpage
    implements Runnable {
        private URL url;

        public FetchWebpage(URL url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod("GET");
                conn.setUseCaches(false);
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Java) SKMCLauncher");
                conn.setDoInput(true);
                conn.setDoOutput(false);
                conn.setReadTimeout(5000);
                conn.connect();
                LauncherUtils.checkInterrupted();
                if (conn.getResponseCode() != 200) {
                    throw new IOException("Did not get expected 200 code, got " + conn.getResponseCode());
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                StringBuilder s = new StringBuilder();
                char[] buf = new char[1024];
                int len = 0;
                while ((len = reader.read(buf)) != -1) {
                    s.append(buf, 0, len);
                }
                String result = s.toString();
                LauncherUtils.checkInterrupted();
                WebpagePanel.this.setDisplay(result, LauncherUtils.concat(this.url, ""));
            }
            catch (IOException e) {
                if (Thread.interrupted()) {
                    return;
                }
                log.log(Level.WARNING, "Failed to fetch page", e);
                WebpagePanel.this.setError("Failed to fetch page: " + e.getMessage());
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                conn = null;
            }
        }
    }
}

