/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.skcraft.launcher.AssetsRoot;
import com.skcraft.launcher.model.minecraft.Asset;
import java.io.File;
import java.util.Map;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetsIndex {
    private boolean virtual;
    private Map<String, Asset> objects;

    public File getObjectPath(@NonNull AssetsRoot assetsRoot, @NonNull String name) {
        if (assetsRoot == null) {
            throw new NullPointerException("assetsRoot is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Asset asset = this.objects.get(name);
        if (asset != null) {
            return assetsRoot.getObjectPath(asset);
        }
        return null;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public Map<String, Asset> getObjects() {
        return this.objects;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setObjects(Map<String, Asset> objects) {
        this.objects = objects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetsIndex)) {
            return false;
        }
        AssetsIndex other = (AssetsIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVirtual() != other.isVirtual()) {
            return false;
        }
        Map<String, Asset> this$objects = this.getObjects();
        Map<String, Asset> other$objects = other.getObjects();
        return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetsIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVirtual() ? 79 : 97);
        Map<String, Asset> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        return result;
    }

    public String toString() {
        return "AssetsIndex(virtual=" + this.isVirtual() + ", objects=" + this.getObjects() + ")";
    }
}

