/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch.runtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import com.skcraft.launcher.launch.runtime.JavaRuntimeFinder;
import java.io.File;

public class JavaRuntime
implements Comparable<JavaRuntime> {
    private final File dir;
    private final String version;
    private final boolean is64Bit;
    private boolean isMinecraftBundled = false;

    @JsonValue
    public File getDir() {
        return this.dir;
    }

    @JsonCreator
    public static JavaRuntime fromDir(String dir) {
        return JavaRuntimeFinder.getRuntimeFromPath(dir);
    }

    @JsonIgnore
    public int getMajorVersion() {
        if (this.version == null) {
            return 0;
        }
        String[] parts = this.version.split("\\.");
        if (parts[0].equals("1") && parts.length > 1) {
            return Integer.parseInt(parts[1]);
        }
        return Integer.parseInt(parts[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaRuntime that = (JavaRuntime)o;
        return Objects.equal(this.dir, that.dir);
    }

    public int hashCode() {
        return Objects.hashCode(this.dir);
    }

    @Override
    public int compareTo(JavaRuntime o) {
        if (this.isMinecraftBundled && !o.isMinecraftBundled) {
            return -1;
        }
        if (!this.isMinecraftBundled && o.isMinecraftBundled) {
            return 1;
        }
        if (this.is64Bit && !o.is64Bit) {
            return -1;
        }
        if (!this.is64Bit && o.is64Bit) {
            return 1;
        }
        if (this.version == null) {
            return 1;
        }
        if (o.version == null) {
            return -1;
        }
        String[] a = this.version.split("[\\._]");
        String[] b = o.version.split("[\\._]");
        int min = Math.min(a.length, b.length);
        for (int i = 0; i < min; ++i) {
            int second;
            int first;
            try {
                first = Integer.parseInt(a[i]);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            try {
                second = Integer.parseInt(b[i]);
            }
            catch (NumberFormatException e) {
                return 1;
            }
            if (first > second) {
                return -1;
            }
            if (first >= second) continue;
            return 1;
        }
        if (a.length == b.length) {
            return 0;
        }
        return a.length > b.length ? -1 : 1;
    }

    public String toString() {
        String version = this.version != null ? this.version : "unknown";
        return String.format("Java %s (%s) (%s)", version, this.is64Bit ? "64-bit" : "32-bit", this.dir);
    }

    public JavaRuntime(File dir, String version, boolean is64Bit) {
        this.dir = dir;
        this.version = version;
        this.is64Bit = is64Bit;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    public boolean isMinecraftBundled() {
        return this.isMinecraftBundled;
    }

    public void setMinecraftBundled(boolean isMinecraftBundled) {
        this.isMinecraftBundled = isMinecraftBundled;
    }
}

