/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth.skin;

import com.skcraft.launcher.auth.microsoft.model.McProfileResponse;
import com.skcraft.launcher.auth.skin.SkinProcessor;
import com.skcraft.launcher.auth.skin.puddingskinapi.PuddingSkinApi;
import com.skcraft.launcher.util.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinecraftSkinService {
    private static final Logger log = Logger.getLogger(MinecraftSkinService.class.getName());

    static byte[] downloadSkin(String textureUrl) throws IOException, InterruptedException {
        return HttpRequest.get(HttpRequest.url(textureUrl)).execute().expectResponseCode(200).returnContent().asBytes();
    }

    public static byte[] fetchSkinHead(McProfileResponse profile) throws InterruptedException {
        try {
            byte[] skin = MinecraftSkinService.downloadSkin(profile.getActiveSkin().getUrl());
            return SkinProcessor.renderHead(skin);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to download or process skin.", e);
            return null;
        }
    }

    public static byte[] fetchSkinHead(String skinUrl) throws InterruptedException, MalformedURLException {
        try {
            byte[] skin = MinecraftSkinService.downloadSkin(skinUrl.toString());
            return SkinProcessor.renderHead(skin);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to download or process skin.", e);
            return null;
        }
    }

    public static byte[] fetchSkinHead(String serverBaseUrl, String uniqueId) throws InterruptedException, MalformedURLException {
        try {
            return MinecraftSkinService.fetchSkinHead(MinecraftSkinService.getSkinUrlStringFromUniqueIdUrl(serverBaseUrl, uniqueId));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to obtain skin url from api server.", e);
            throw new RuntimeException(e);
        }
    }

    private static String getSkinUrlStringFromUniqueIdUrl(String serverBaseUrl, String uniqueId) throws Exception {
        uniqueId = uniqueId.replaceAll("-", "");
        return PuddingSkinApi.getSkinUrlFromUniqueIdUrl(new URL(serverBaseUrl + uniqueId));
    }
}

