/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.update;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.skcraft.concurrency.DefaultProgress;
import com.skcraft.concurrency.ProgressFilter;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.model.minecraft.ReleaseList;
import com.skcraft.launcher.model.minecraft.Version;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.update.BaseUpdater;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class Updater
extends BaseUpdater
implements Callable<Instance>,
ProgressObservable {
    private static final Logger log = Logger.getLogger(Updater.class.getName());
    private final ObjectMapper mapper = new ObjectMapper();
    private final Installer installer;
    private final Launcher launcher;
    private final Instance instance;
    private boolean online;
    private List<URL> librarySources = new ArrayList<URL>();
    private List<URL> assetsSources = new ArrayList<URL>();
    private ProgressObservable progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.preparingUpdate"));

    public Updater(@NonNull Launcher launcher, @NonNull Instance instance) {
        super(launcher);
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.installer = new Installer(launcher.getInstallerDir());
        this.launcher = launcher;
        this.instance = instance;
        this.librarySources.add(launcher.propUrl("librariesSource"));
        this.assetsSources.add(launcher.propUrl("assetsSource"));
    }

    @Override
    public Instance call() throws Exception {
        boolean updateCapable;
        log.info("Checking for an update for '" + this.instance.getName() + "'...");
        this.instance.getContentDir();
        boolean updateRequired = !this.instance.isInstalled();
        boolean updateDesired = this.instance.isUpdatePending() || updateRequired;
        boolean bl = updateCapable = this.instance.getManifestURL() != null;
        if (!this.online && updateRequired) {
            log.info("Can't update " + this.instance.getTitle() + " because offline");
            String message = SharedLocale.tr("updater.updateRequiredButOffline");
            throw new LauncherException("Update required but currently offline", message);
        }
        if (updateDesired && !updateCapable) {
            if (updateRequired) {
                log.info("Update required for " + this.instance.getTitle() + " but there is no manifest");
                String message = SharedLocale.tr("updater.updateRequiredButNoManifest");
                throw new LauncherException("Update required but no manifest", message);
            }
            log.info("Can't update " + this.instance.getTitle() + ", but update is not required");
            return this.instance;
        }
        if (updateDesired) {
            log.info("Updating " + this.instance.getTitle() + "...");
            this.update(this.instance);
        } else {
            log.info("No update found for " + this.instance.getTitle());
        }
        return this.instance;
    }

    private VersionManifest readVersionManifest(Manifest manifest) throws IOException, InterruptedException {
        VersionManifest version = manifest.getVersionManifest();
        URL url = HttpRequest.url(this.launcher.getProperties().getProperty("versionManifestUrl"));
        if (version == null) {
            version = Updater.fetchVersionManifest(url, manifest);
        }
        if (version.getDownloads().isEmpty()) {
            VersionManifest otherManifest = Updater.fetchVersionManifest(url, manifest);
            version.setDownloads(otherManifest.getDownloads());
            version.setAssetIndex(otherManifest.getAssetIndex());
        }
        this.mapper.writeValue(this.instance.getVersionPath(), (Object)version);
        return version;
    }

    private static VersionManifest fetchVersionManifest(URL url, Manifest manifest) throws IOException, InterruptedException {
        ReleaseList releases = HttpRequest.get(url).execute().expectResponseCode(200).returnContent().asJson(ReleaseList.class);
        Version relVersion = releases.find(manifest.getGameVersion());
        return HttpRequest.get(HttpRequest.url(relVersion.getUrl())).execute().expectResponseCode(200).returnContent().asJson(VersionManifest.class);
    }

    protected void update(Instance instance) throws Exception {
        instance.setLocal(true);
        Persistence.commitAndForget(instance);
        log.info("Reading package manifest...");
        this.progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.readingManifest"));
        Manifest manifest = this.installPackage(this.installer, instance);
        manifest.update(instance);
        log.info("Reading version manifest...");
        this.progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.readingVersion"));
        VersionManifest version = this.readVersionManifest(manifest);
        this.progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.buildingDownloadList"));
        File jarPath = this.launcher.getJarPath(version);
        VersionManifest.Artifact clientJar = version.getDownloads().get("client");
        URL jarSource = HttpRequest.url(clientJar.getUrl());
        log.info("JAR at " + jarPath.getAbsolutePath() + ", fetched from " + jarSource);
        this.installJar(this.installer, clientJar, jarPath, jarSource);
        log.info("Enumerating libraries to download...");
        URL url = manifest.getLibrariesUrl();
        if (url != null) {
            log.info("Added library source: " + url);
            this.librarySources.add(0, url);
        }
        this.progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.collectingLibraries"));
        this.installLibraries(this.installer, manifest, this.launcher.getLibrariesDir(), this.librarySources);
        log.info("Enumerating assets to download...");
        this.progress = new DefaultProgress(-1.0, SharedLocale.tr("instanceUpdater.collectingAssets"));
        this.installAssets(this.installer, version, HttpRequest.url(version.getAssetIndex().getUrl()), this.assetsSources);
        log.info("Executing download phase...");
        this.progress = ProgressFilter.between(this.installer.getDownloader(), 0.0, 0.98);
        this.installer.download();
        log.info("Executing install phase...");
        this.progress = ProgressFilter.between(this.installer, 0.98, 1.0);
        this.installer.execute(this.launcher);
        this.installer.executeLate(this.launcher);
        log.info("Completing...");
        this.complete();
        log.info("Writing instance information...");
        instance.setVersion(manifest.getVersion());
        instance.setUpdatePending(false);
        instance.setInstalled(true);
        instance.setLocal(true);
        Persistence.commitAndForget(instance);
        log.log(Level.INFO, instance.getName() + " has been updated to version " + manifest.getVersion() + ".");
    }

    @Override
    public double getProgress() {
        return this.progress.getProgress();
    }

    @Override
    public String getStatus() {
        return this.progress.getStatus();
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }
}

