/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.google.common.io.Files;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class FileCopy
implements InstallTask {
    private static final Logger log = Logger.getLogger(FileCopy.class.getName());
    private final File from;
    private final File to;

    public FileCopy(@NonNull File from, @NonNull File to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public void execute(Launcher launcher) throws IOException {
        log.log(Level.INFO, "Copying to {0} (from {1})...", new Object[]{this.to.getAbsoluteFile(), this.from.getName()});
        this.to.getParentFile().mkdirs();
        Files.copy(this.from, this.to);
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("installer.copyingFile", this.from, this.to);
    }
}

